TITLE   'Transient Heat Conduction'			           { 3d228.pde }
SELECT     errlim=1e-3     ngrid=1     spectral_colors
COORDINATES   cartesian3				{ Student Edition }	
VARIABLES   temp( threshold=0.2)
DEFINITIONS
   L=0.1     r0=0.015     z0=0.02
   k     rcp     heat=0             				{ Thermal parameters }
   in_fluxd=1e6
   fluxd_x=-k*dx(temp)     fluxd_y=-k*dy(temp)     fluxd_z=-k*dz(temp)
   fluxd=vector( fluxd_x, fluxd_y, fluxd_z)     fluxdm=magnitude( fluxd)
   f_angle=sign(fluxd_y)*arccos(fluxd_x/fluxdm)/pi*180
INITIAL VALUES
   temp=300
EQUATIONS
   div( fluxd)+ rcp*dt( temp)=heat
EXTRUSION						{ Parallel surfaces }
   surface 'bottom' z=0	
   layer 'iron'	 					
   surface 'middle' z=z0					{ Interface }
   layer 'copper'						
   surface 'top' z=L
BOUNDARIES
   surface 'bottom'  natural( temp)= 0		{ Insulated }	
   surface 'top'  natural( temp)=-in_fluxd		{ Input flux density }
region 'domain'    					{ Full solution domain }	
   layer 'iron' k=82  rcp=7.87e3*449		{ Fe }
   layer 'copper'  void
   start 'outer' (0,0)   natural( temp)=0
      line to (L,0) value( temp)=300 line to (L,L)  to (0,L)  close
region 'cylinder'							
   layer 'iron' k=82  rcp=7.87e3*449 		{ Fe }         		
   layer 'copper' k=400  rcp=8.96e3* 385		{ Redefine void to Cu }
   start (L/4+r0,L/4)   arc( center=L/4,L/4) angle=360
TIME 0 to 1e6
PLOTS
for t=1, 10, 100, 1e3, 1e4, 1e5, 1e6
   contour( temp) painted on x=y
END

